/*
 * Decompiled with CFR 0.152.
 */
package scheduler;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.TreeSet;
import scheduler.YearSched;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTheContentOfLibrary {
    public static Hashtable<Integer, YearSched> getHTSched() {
        File file = new File("library.dat");
        try {
            if (file.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                Hashtable ht = (Hashtable)ois.readObject();
                ois.close();
                return ht;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        Hashtable<Integer, YearSched> ht = ListTheContentOfLibrary.getHTSched();
        if (ht != null) {
            Collection<YearSched> c = ht.values();
            for (YearSched ys : c) {
                System.out.println("year of effectivity: " + ys.getYearOfEffectivity() + "\nyear of end of effectivity: " + ys.getYearEndOfEffectivity());
                Hashtable<Double, Double> htSched = ys.getSchedule();
                TreeSet<Double> ssContriSet = new TreeSet<Double>(htSched.keySet());
                System.out.println("SS \t EC");
                for (Double ssContri : ssContriSet) {
                    System.out.println(ssContri + "\t" + htSched.get(ssContri));
                }
                System.out.println();
            }
        }
    }
}

