/*
 * Decompiled with CFR 0.152.
 */
package scheduler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.TreeSet;
import scheduler.YearSched;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler {
    Hashtable<Integer, YearSched> htCurrentSchedule;

    public static void main(String[] args) {
        Scheduler s = new Scheduler();
        s.iniatialized();
        s.startApp();
    }

    private void startApp() {
        while (true) {
            this.clearScreen(10);
            int option = this.menu();
            this.doTask(option);
        }
    }

    private int menu() {
        try {
            System.out.println("\t\tContribution Schedule Utility Menu ");
            System.out.println("\t1. Add New Schedule ");
            System.out.println("\t2. View Current Content of Library.dat ");
            System.out.println("\t3. Delete Schedule from Library.dat ");
            System.out.println("\t4. Exit ");
            System.out.println();
            System.out.print("\tEnter your choice (1-3): ");
            Scanner scan = new Scanner(System.in);
            int option = scan.nextInt();
            return option;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void doTask(int task) {
        if (task == 0) {
            System.out.println("Task is 0");
            return;
        }
        if (task == 1) {
            this.onTaskTwo();
        }
        if (task == 2) {
            this.clearScreen(10);
            this.viewContent();
        }
        if (task == 3) {
            this.onDeleteSchedule();
        }
        if (task == 4) {
            this.onExit();
        }
    }

    private void addNewSched() {
        this.clearScreen(5);
        System.out.println("ADD NEW SCHEDULE");
        String ec = "10.0";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter Year of effectivity: ");
            String yoe = br.readLine();
            System.out.print("Enter Year end of effectivity: (enter 999999 if this is the latest schedule)");
            String yee = br.readLine();
            Hashtable<Double, Double> hc = new Hashtable<Double, Double>();
            double s = 0.0;
            do {
                System.out.print("Enter SS Amount (enter 0.0 to end): ");
                String ss = br.readLine();
                if (!ss.toString().equals(0.0)) {
                    System.out.print("Enter EC Amount : ");
                    ec = br.readLine();
                }
                s = Double.parseDouble(ss);
                double c = Double.parseDouble(ec);
                if (s == 0.0 && c == 0.0) continue;
                hc.put(s, c);
            } while (s != 0.0);
            YearSched ys = new YearSched(Integer.parseInt(yoe), Integer.parseInt(yee), hc);
            this.htCurrentSchedule.put(Integer.parseInt(yoe), ys);
            File file = new File("library.dat");
            Scheduler.writeObject(this.htCurrentSchedule, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onDeleteSchedule() {
        this.clearScreen(10);
        System.out.print("Enter year of effectivity schedule to delete: ");
        Scanner scan = new Scanner(System.in);
        int yoe = scan.nextInt();
        if (this.htCurrentSchedule.containsKey(yoe)) {
            YearSched ys = this.htCurrentSchedule.get(yoe);
            System.out.println();
            this.viewYearSchedDetails(ys);
            System.out.println();
            System.out.print("Delete this schedule: Y or N ");
            String reply = scan.next();
            if (reply.equalsIgnoreCase("y") || reply.equalsIgnoreCase("yes")) {
                this.htCurrentSchedule.remove(yoe);
                System.out.print("Schedule successfully deleted.");
            } else {
                System.out.print("Unrecognized response. Delete aborted.");
            }
        }
    }

    private void onTaskTwo() {
        if (!this.needToSetYearEndOfEffectivityOfLastSchedule()) {
            System.out.println("\tChanging of Year End Of Effectivity NOT successful.");
            return;
        }
        System.out.println("\tChanging of Year End Of Effectivity successful.");
        this.addNewSched();
    }

    private boolean needToSetYearEndOfEffectivityOfLastSchedule() {
        this.clearScreen(5);
        try {
            this.htCurrentSchedule = Scheduler.getHTSched();
            if (this.htCurrentSchedule == null) {
                this.htCurrentSchedule = new Hashtable();
                System.out.println("htCurrentSchedule is null and properly initialized.");
                return true;
            }
            System.out.print("\tEnter year of effectivity to change: ");
            Scanner scan = new Scanner(System.in);
            int yoe = scan.nextInt();
            YearSched ys = this.htCurrentSchedule.get(yoe);
            System.out.println();
            this.viewYearSchedDetails(ys);
            System.out.println();
            System.out.print("\tEnter new year end of effectivity for this schedule: ");
            int yee = scan.nextInt();
            ys.setYearEndOfEffectivity(yee);
            this.htCurrentSchedule.put(yoe, ys);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void viewContent() {
        if (this.htCurrentSchedule != null) {
            Collection<YearSched> c = this.htCurrentSchedule.values();
            for (YearSched ys : c) {
                this.viewYearSchedDetails(ys);
                System.out.println();
            }
        } else {
            System.out.println("SCHEDULER: Schedule is null.");
            return;
        }
    }

    private void viewYearSchedDetails(YearSched ys) {
        System.out.println("year of effectivity: " + ys.getYearOfEffectivity() + "\nyear of end of effectivity: " + ys.getYearEndOfEffectivity());
        Hashtable<Double, Double> htSched = ys.getSchedule();
        TreeSet<Double> ssContriSet = new TreeSet<Double>(htSched.keySet());
        System.out.println("SS \t EC");
        for (Double ssContri : ssContriSet) {
            System.out.println(ssContri + "\t" + htSched.get(ssContri));
        }
    }

    private void iniatialized() {
        this.htCurrentSchedule = Scheduler.getHTSched();
        if (this.htCurrentSchedule == null) {
            this.htCurrentSchedule = new Hashtable();
        } else {
            System.out.println("Schedule is not null, size is: " + this.htCurrentSchedule.size());
        }
    }

    public static Hashtable<Integer, YearSched> getHTSched() {
        File file = new File("library.dat");
        try {
            if (file.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                Hashtable ht = (Hashtable)ois.readObject();
                ois.close();
                return ht;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean writeObject(Hashtable<Integer, YearSched> object, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void clearScreen(int x) {
        for (int i = 0; i < x; ++i) {
            System.out.println();
        }
    }

    private void onExit() {
        File file = new File("library.dat");
        Scheduler.writeObject(this.htCurrentSchedule, file);
        System.exit(0);
    }
}

