/*
 * Decompiled with CFR 0.152.
 */
package scheduler;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YearSched
implements Serializable {
    private int yearOfEffectivity;
    private int yearEndOfEffectivity;
    private double ssAmt;
    private double ecAmt;
    private Hashtable<Double, Double> htSchedule;
    private static final long serialVersionUID = 69L;

    public YearSched() {
    }

    public YearSched(int yoe, int yee, Hashtable<Double, Double> ht) {
        this.yearOfEffectivity = yoe;
        this.yearEndOfEffectivity = yee;
        this.htSchedule = ht;
    }

    public Hashtable<Double, Double> getSchedule() {
        return this.htSchedule;
    }

    public void setSchedule(Hashtable<Double, Double> ht) {
        this.htSchedule = ht;
    }

    public int getYearOfEffectivity() {
        return this.yearOfEffectivity;
    }

    public int getYearEndOfEffectivity() {
        return this.yearEndOfEffectivity;
    }

    public void setYearOfEffectivity(int yoe) {
        this.yearOfEffectivity = yoe;
    }

    public void setYearEndOfEffectivity(int yee) {
        this.yearEndOfEffectivity = yee;
    }

    public String toString() {
        return String.valueOf(this.yearOfEffectivity);
    }

    public double getMinimumEC() {
        if (this.htSchedule != null) {
            TreeSet<Double> set = new TreeSet<Double>(this.htSchedule.values());
            return set.first();
        }
        return 10.0;
    }

    public double getMaximumEC() {
        if (this.htSchedule != null) {
            TreeSet<Double> set = new TreeSet<Double>(this.htSchedule.values());
            return set.last();
        }
        return 10.0;
    }

    public boolean containsEC(double ec) {
        if (this.htSchedule != null) {
            TreeSet<Double> set = new TreeSet<Double>(this.htSchedule.values());
            return set.contains(ec);
        }
        return false;
    }
}

